//$**************************************************************
//$					Copyright (C) 2010 by L-1 Identity Solutions
//$  Name:        $Workfile: TPAPI Sample AppDlg.cpp $
//$  Author:      $Author: Jmacdonald $
//$  Description:	TPAPI Sample Application
//$
// 
#include "stdafx.h"
#include <crtdbg.h>

#include "..\include\memtiff.h"
#include "..\include\salijag1.h"
#include ".\TPAPI Sample App.h"
#include ".\TPAPI Sample AppDlg.h"
#include ".\CaptureDlg.h"

extern long ImgCallbk(int,unsigned char *,unsigned short,unsigned short);
extern struct s_ctypeInfo cTypeInfo[];

#define POLL_TIME_MS             3000
#define NUM_SCANTYPES            4
#define DFLT_CMODE               (CMODE_REVIEW|CMODE_RTQA)
#define DFLT_MIN_GOODAREA        50			// Minimum area of good contact

// Global Var
CCaptureDlg *captureDlg;
HCURSOR hIdxCursor;

char fngrName[NUM_FNGRS][22] = { 
   "Slap - Left Four",
   "Slap - Left Thumb",
   "Slap - Right Four",
   "Slap - Right Thumb",
   "Slap - Thumbs",
   "Roll - Left Thumb",
   "Roll - Left Index",
   "Roll - Left Middle",
   "Roll - Left Ring",
   "Roll - Left Little",
   "Roll - Right Thumb",
   "Roll - Right Index",
   "Roll - Right Middle",
   "Roll - Right Ring",
   "Roll - Right Little",
   "Roll - Left Hand",
   "Roll - Left Writers",
   "Slap - Left Palm",
   "Roll - Right Hand",
   "Roll - Right Writers",
   "Slap - Right Palm"
};

char scannerName[NUM_SCANTYPES][22] = { 
   "Hand",
   "Finger",
   "Four Finger",
   "Palm"
};

const char strErrTPAPI[TPAPI_MAXERR-TPAPI_ERR+1][32] = 
{
   "Undefined Error                ",
   "API Not Initialized            ",
   "Out of System Resources        ",
   "Device Unavailable             ",
   "Too Many Devices on the Bus    ",
   "Device Timeout                 ",
   "Parameter Out of Range         ",
   "Invalid Command State          ",
   "Memory Access Violation        ",
   "Invalid Response From Device   ",
   "Bad or Missing Image File      "
};

const char strErrSALIInt[SALI_XCTRL_ABORT-SALI_INTERNAL_ERR+1][34] = 
{
   "SALI - Internal Error            ",
   "SALI - Out of Resources          ",
   "SALI - Adapter Access Error      ",
   "SALI - Adapter Mapping Error     ",
   "SALI - Bus Reset                 ",
   "SALI - Device Unavailable        ",
   "SALI - Wait Object Error         ",
   "SALI - Bad Channel               ",
   "SALI - Isochronous Request Error ",
   "SALI - Video Receiver Error      ",
   "SALI - Async Read Error          ",
   "SALI - Async Write Error         ",
   "SALI - CSR Address Error         ",
   "SALI - CSR Write Error           ",
   "SALI - Invalid Response          ",
   "SALI - Failure Response          ",
   "SALI - Device Timeout            ",
   "SALI - Bad Pipe                  ",
   "SALI - XCTRL Abort               "
};

const char strErrSALIUser[SALI_BAD_SCANNER_INDEX-SALI_USER_ERR+1][32] = 
{
   "SALI - User Error              ",
   "SALI - Not Initialized         ",
   "SALI - Buffer Too Big          ",
   "SALI - Buffer Too Small        ",
   "SALI - Buffer Too Many Frames  ",
   "SALI - Video Stopped           ",
   "SALI - Video Timeout           ",
   "SALI - Terminated              ",
   "SALI - Bad Scanner Index       "
};

eCaptureType cTypes[NUM_FNGRS] = { 
   CTYPE_SLAP_LFOUR,
   CTYPE_SLAP_LTHUMB,
   CTYPE_SLAP_RFOUR,
   CTYPE_SLAP_RTHUMB,
   CTYPE_SLAP_THUMBS,
   CTYPE_ROLL_LTHUMB,
   CTYPE_ROLL_LINDEX,
   CTYPE_ROLL_LMIDDLE,
   CTYPE_ROLL_LRING,
   CTYPE_ROLL_LLITTLE,
   CTYPE_ROLL_RTHUMB,
   CTYPE_ROLL_RINDEX,
   CTYPE_ROLL_RMIDDLE,
   CTYPE_ROLL_RRING,
   CTYPE_ROLL_RLITTLE,
   CTYPE_HAND,
   CTYPE_HAND,
   CTYPE_SLAP_LPALM,
   CTYPE_HAND,
   CTYPE_HAND,
   CTYPE_SLAP_RPALM
};

//=============================================================
//                   Utility Functions
//=============================================================
//
const char *GetErrorMsg(long errCode)
{
   static char errMsg[30];

   if ((errCode >= TPAPI_ERR) && (errCode <= TPAPI_MAXERR))
      return(strErrTPAPI[errCode-TPAPI_ERR]);
   else if ((errCode >= SALI_INTERNAL_ERR) && (errCode <= SALI_XCTRL_ABORT))
      return(strErrSALIInt[errCode-SALI_INTERNAL_ERR]);
   else if ((errCode >= SALI_USER_ERR) && (errCode <= SALI_BAD_SCANNER_INDEX))
      return(strErrSALIUser[errCode-SALI_USER_ERR]);
   else
   {
      sprintf(errMsg,"Error %d",errCode);
      return(errMsg);
   }
}

//
// LoadAnimatedCursor: Loads an animated cursor resource
//
HCURSOR LoadAniCursor(UINT nID)
{
   HINSTANCE hInst=AfxGetInstanceHandle();
   HRSRC hRes=FindResource(hInst,MAKEINTRESOURCE(nID),"ANICURSORS");
   DWORD dwSize=SizeofResource(hInst, hRes);
   HGLOBAL hGlob=LoadResource(hInst, hRes);
   LPBYTE pBytes=(LPBYTE)LockResource(hGlob); 
   return (HCURSOR)CreateIconFromResource(pBytes,dwSize,FALSE,0x00030000);
}

void DrawTransparent(CBitmap *pBmp,CDC *pDC,int x,int y,int w,
							int h,COLORREF crColor)
{
   CDC dcImage;
   dcImage.CreateCompatibleDC(pDC);
   CBitmap* pOldBitmapImage = dcImage.SelectObject(pBmp);
   pDC->TransparentBlt(x,y,w,h,&dcImage,0,0,w,h,crColor);
   dcImage.SelectObject(pOldBitmapImage);
}

//=============================================================
//    SetupPalette
//       Initializes palette based on dmode
//
//       [IN]  plain or decorated image mode (dMode)
//             ptr to palette, size of palette
//=============================================================
void SetupPalette(int dMode,RGBQUAD *pColors,int numQuads)
{
   for (int j = 0; j < numQuads; j++)
   {     // If decorated & odd, mark as red/pink, else greyscale
      pColors[j].rgbBlue = j;					// B
      pColors[j].rgbGreen = j;				// G
      pColors[j].rgbRed = ((dMode & DECORATED_RTQA) && (j % 2)) ? 255 : j;	// R
      pColors[j].rgbReserved = 0;
   }
   if ((dMode & DECORATED_HANDSPEED) && (numQuads > 3))
   {		// Hand roll speed indicators
      pColors[0].rgbBlue = 0;					// B	- Red - Too Fast - Refused
      pColors[0].rgbGreen = 0;				// G
      pColors[0].rgbRed = 255;				// R
      pColors[1].rgbBlue = 0;					// B	- Yellow - Too Fast
      pColors[1].rgbGreen = 255;				// G
      pColors[1].rgbRed = 255;				// R
      pColors[2].rgbBlue = 0;					// B	- Green - Good
      pColors[2].rgbGreen = 255;				// G
      pColors[2].rgbRed = 0;				   // R
      pColors[3].rgbBlue = 255;				// B	- Blue - Too Slow
      pColors[3].rgbGreen = 0;				// G
      pColors[3].rgbRed = 0;				   // R
	}
}

//=============================================================
//		SetupBitmap
//			Creates empty BITMAP for drawing on display window
//
//			[IN]  plain or decorated image mode (dMode)
//					X, Y dimensions of bitmap
//			[OUT] ptr to CBitmap object and ptr to pixel data
//					MUST be deleted by caller
//=============================================================
long SetupBitmap(int dMode,int Xsize,int Ysize,
					CBitmap *pBitmap,	unsigned char **ppBitmapData)
{
	HDC hdcScreen;
	HDC phDC;
	LPBYTE DIBpix;

	LPBITMAPINFO pDIBinfo = (LPBITMAPINFO)GlobalAlloc(GMEM_FIXED, 
		sizeof(BITMAPINFOHEADER) + (256 * sizeof(RGBQUAD)));
	if (pDIBinfo == NULL) return(TPAPI_OUTOFRESOURCES);

		// initialize DIB 
	pDIBinfo->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	pDIBinfo->bmiHeader.biWidth = Xsize;
	pDIBinfo->bmiHeader.biHeight = -(long)Ysize;
	pDIBinfo->bmiHeader.biPlanes = 1;
	pDIBinfo->bmiHeader.biBitCount = 8;
	pDIBinfo->bmiHeader.biCompression = BI_RGB;
	pDIBinfo->bmiHeader.biSizeImage = (long)Xsize * Ysize;
	pDIBinfo->bmiHeader.biXPelsPerMeter = 0;
	pDIBinfo->bmiHeader.biYPelsPerMeter = 0;
	pDIBinfo->bmiHeader.biClrUsed = 0;
	pDIBinfo->bmiHeader.biClrImportant = 0;

		// Build the pallet.
	DIBpix = (LPBYTE)((LPBYTE)pDIBinfo + sizeof(BITMAPINFOHEADER));
   SetupPalette(dMode,(RGBQUAD*)DIBpix, 256);

	hdcScreen = CreateDC("DISPLAY", NULL, NULL, NULL); 
	phDC = CreateCompatibleDC(hdcScreen); 

		// create static bitmap for image display (allocs pixel memory)
	HBITMAP hBitmap = CreateDIBSection(phDC,pDIBinfo,DIB_RGB_COLORS,
		(void **)&DIBpix,NULL,0);
	if (hBitmap)
	{
		pBitmap->DeleteObject();
		pBitmap->Attach(hBitmap);
			// initialize to white pixels
		for (int k = 0; k < (Xsize * Ysize); k++)
			DIBpix[k] = 255;
	}
		// free up resources
	DeleteDC(phDC);
	DeleteDC(hdcScreen);
	if (pDIBinfo) GlobalFree(pDIBinfo);

	if (hBitmap == NULL)
		return(TPAPI_OUTOFRESOURCES);

	*ppBitmapData = DIBpix;
	return(TPAPI_NOERROR);
}

//=============================================================
//					CTPAPISampleAppDlg dialog
//=============================================================
//
CTPAPISampleAppDlg::CTPAPISampleAppDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTPAPISampleAppDlg::IDD, pParent)
{
      // report any memory leaks to debug Output window
   _CrtSetDbgFlag(_CrtSetDbgFlag(_CRTDBG_REPORT_FLAG)|
      _CRTDBG_ALLOC_MEM_DF|_CRTDBG_LEAK_CHECK_DF);

   m_hIcon = AfxGetApp()->LoadIcon(IDI_L1ID);
   bTPAPIInitialized = false;
   m_deviceConnected = false;
   m_hDev = INVALID_HANDLE;
   XSize = 800;
   YSize = 750;
   m_RTQAThrhld = DFLT_MIN_GOODAREA;
   m_CaptureMode = DFLT_CMODE;
   bmpMutex = new CMutex();
   hIdxCursor = LoadAniCursor(IDR_IDX_CURSOR);
   bLogo.LoadBitmap(IDB_LOGO);
   bApp.LoadBitmap(IDB_TITLE);
}

CTPAPISampleAppDlg::~CTPAPISampleAppDlg()
{
   bApp.DeleteObject();
   bLogo.DeleteObject();
   DeleteObject(hIdxCursor);
   m_bmImage.bm.DeleteObject();
   delete bmpMutex;
}

BEGIN_MESSAGE_MAP(CTPAPISampleAppDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_TIMER()
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_USER_INIT, OnUserInit)
	ON_BN_CLICKED(IDC_CHK_RTQA, OnBnClickedRTQA)
	ON_BN_CLICKED(IDC_CHK_REVIEW, OnBnClickedReview)
	ON_BN_CLICKED(IDC_BTN_PREVIEW, OnBnClickedBtnPreview)
	ON_BN_CLICKED(IDC_RADIO_500, OnBnClickedRadio500)
	ON_BN_CLICKED(IDC_RADIO_1000, OnBnClickedRadio1000)
	ON_BN_CLICKED(IDC_BTN_CALIBRATE, OnBnClickedBtnCalibrate)
	ON_BN_CLICKED(IDC_BTN_SAVEAS, OnBnClickedBtnSaveas)
   ON_BN_CLICKED(IDC_CHK_AUTOCAP, OnBnClickedAutoCap)
   ON_CBN_SELCHANGE(IDC_COMBO_FNGR, OnCbnSelchangeComboFngr)
   ON_BN_CLICKED(IDC_BTN_REFRESH, &OnBnClickedBtnRefresh)
   ON_CBN_SELCHANGE(IDC_COMBO_DEVICE, &CTPAPISampleAppDlg::OnCbnSelchangeDevice)
END_MESSAGE_MAP()

//------------------------------------------------------
//		OnInitDialog
//------------------------------------------------------
BOOL CTPAPISampleAppDlg::OnInitDialog()
{
	long r;
	CDialog::OnInitDialog();

	// Set the icon for this dialog.
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

		// Allocate a bitmap buffer for thumbnail display
	if ((r = SetupBitmap(UNDECORATED,XSize,YSize,
			&m_bmImage.bm,&pBitmapData)) != TPAPI_NOERROR) 
		MessageBox(GetErrorMsg(r),"Initialization Error",MB_ICONERROR);

		// Initialize fingerprint ComboBox
	m_fngr = (CComboBox*) GetDlgItem(IDC_COMBO_FNGR);
	for (int i = 0; i < NUM_FNGRS; i++)
		m_fngr->InsertString(i,fngrName[i]);
	m_fngr->SetCurSel(0);

		// Initialize calibration ComboBox
	m_calib = (CComboBox*) GetDlgItem(IDC_COMBO_CALIB);
	for (int i = 0; i < NUM_SCANTYPES; i++)
		m_calib->InsertString(i,scannerName[i]);
	m_calib->SetCurSel(0);
   m_BtnCalibrate = ((CButton*)GetDlgItem(IDC_BTN_CALIBRATE));
   m_BtnStartCapture = ((CButton*)GetDlgItem(IDC_BTN_PREVIEW));

	((CButton*)GetDlgItem(IDC_RADIO_ONE))->SetCheck(BST_CHECKED);
	((CButton*)GetDlgItem(IDC_CHK_RTQA))->SetCheck(BST_CHECKED);
	((CEdit*)GetDlgItem(IDC_EDIT_RTQA))->SetWindowText("50");
	((CButton*)GetDlgItem(IDC_CHK_REVIEW))->SetCheck(BST_CHECKED);
	m_chkAutoCap = (CButton*)GetDlgItem(IDC_CHK_AUTOCAP);
   m_chkAutoCap->SetCheck(BST_CHECKED);
	((CButton*)GetDlgItem(IDC_RADIO_INK))->SetCheck(BST_CHECKED);
	((CButton*)GetDlgItem(IDC_RADIO_500))->SetCheck(BST_CHECKED);
   OnCbnSelchangeComboFngr();

   m_device = (CComboBox*)GetDlgItem(IDC_COMBO_DEVICE);
   m_device->ResetContent();

		// Initialize API
	GetDlgItem(IDC_STATUS)->SetWindowText("Initializing...");
	PostMessage(WM_USER_INIT,NULL,NULL);
	return TRUE;  // return TRUE  unless you set the focus to a control
}

afx_msg void CTPAPISampleAppDlg::OnClose(void)
{
   if (bTPAPIInitialized)
   {
      if (m_hDev != INVALID_HANDLE)
      {
         TP_CloseDevice(m_hDev);
         m_hDev = INVALID_HANDLE;
      }
      TP_TerminateAPI();
      bTPAPIInitialized = false;
   }   
   CDialog::OnClose();
}

//-------------------------------------------------------
//		OnPaint
//-------------------------------------------------------
void CTPAPISampleAppDlg::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	if (IsIconic())
	{
		SendMessage(WM_ICONERASEBKGND, 
			reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

			// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		// Paint Logo
		RECT r;
		GetDlgItem(IDC_LOGO)->GetWindowRect(&r);
		ScreenToClient(&r);
		DrawTransparent(&bLogo,&dc,r.left,r.top,r.right-r.left,r.bottom-r.top,RGB(255,0,0));

		// Paint Application Title
		GetDlgItem(IDC_TITLE)->GetWindowRect(&r);
		ScreenToClient(&r);
		DrawTransparent(&bApp,&dc,r.left,r.top,r.right-r.left,r.bottom-r.top,RGB(255,0,0));

		// Paint Fingerprint image window
		BITMAP bm;
		bmpMutex->Lock();
		if (m_bmImage.bm.GetBitmap(&bm))
		{
			CDC dcImage;
			dcImage.CreateCompatibleDC(&dc);
			dcImage.SelectObject(&m_bmImage.bm);

			CRect r;
			GetDlgItem(IDC_IMAGE)->GetWindowRect(&r);
			ScreenToClient(&r);
			int Ysize = (YSize > XSize) ? r.bottom-r.top : ((r.right-r.left) * YSize) / XSize;
			int Xsize = (XSize > YSize) ? r.right-r.left : ((r.bottom-r.top) * XSize) / YSize;
			int imgXPos = (r.Width() - Xsize) / 2;
			int imgYPos = (r.Height() - Ysize) / 2;
			dc.SetStretchBltMode(COLORONCOLOR);
			dc.StretchBlt(r.left+imgXPos,r.top+imgYPos,Xsize,Ysize,&dcImage,
				0,0,XSize,YSize,SRCCOPY); 
		}
		bmpMutex->Unlock();
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CTPAPISampleAppDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

//------------------------------------------------------
//		OnUserInit
//------------------------------------------------------
LRESULT CTPAPISampleAppDlg::OnUserInit(WPARAM,LPARAM)
{
   HCURSOR hCur = SetCursor(hIdxCursor);

   U32 numDev = MAX_DEVLIST;
   long r = TP_InitializeAPI();
   SetCursor(hCur);
   if (r == TPAPI_NOERROR)
      bTPAPIInitialized = true;
   else
      MessageBox(GetErrorMsg(r),"Initialization Error",MB_ICONERROR);
   if (r == TPAPI_NOERROR)
      OnBnClickedBtnRefresh();

//   unsigned long capDelay, capTmOut, altCapTmOut;
//   r = GetSlapAutoCapTimeouts(&capDelay, &capTmOut, &altCapTmOut);
//   r = SetSlapAutoCapTimeouts(5, 50, 20);

//   unsigned long numFngrs;
//   r = GetSlapAutoCapPrimaryFngrs(&numFngrs);
//   r = SetSlapAutoCapPrimaryFngrs(4);

      // Start Status Timer
   if (bTPAPIInitialized)
   {
      m_deviceConnected = true;
      SetTimer(ID_UIUPDATE_TIMER,POLL_TIME_MS,NULL);
   }
   return(1);
}

//-------------------------------------------------------
//		OnTimer
//			Check Device Status
//-------------------------------------------------------
void CTPAPISampleAppDlg::OnTimer(UINT_PTR nIDEvent) 
{
      // Check Connection Status
   if (nIDEvent == ID_UIUPDATE_TIMER)
      UpdateDeviceStatus();

   CDialog::OnTimer(nIDEvent);
}

//-------------------------------------------------------
//		OnCbnSelchangeComboFngr
//			Update the autocapture mode controls
//-------------------------------------------------------
void CTPAPISampleAppDlg::OnCbnSelchangeComboFngr()
{
   int nShow;
   enum eCaptureType capType;

   capType = cTypes[m_fngr->GetCurSel()];
   if (cTypeInfo[capType].base_ctype == CTYPE_ROLL)
      nShow = SW_SHOW;
   else nShow = SW_HIDE;

   GetDlgItem(IDC_RADIO_INK)->ShowWindow(nShow);
   GetDlgItem(IDC_RADIO_NOINK)->ShowWindow(nShow);

   bool bSupported = false;
   if (m_deviceConnected && 
      (TP_IsAutoCaptureSupported(m_hDev, capType, &bSupported)) == TPAPI_NOERROR)
   {
      if (bSupported)
         m_chkAutoCap->EnableWindow(true);
      else
      {
         m_chkAutoCap->EnableWindow(false);
         m_chkAutoCap->SetCheck(BST_UNCHECKED);
      }
   }  
}

//-------------------------------------------------------
//		OnBnClickedBtnPreview
//			Capture fingerprint image
//-------------------------------------------------------
void CTPAPISampleAppDlg::OnBnClickedBtnPreview()
{
   CButton *idcBtn;
   enum eCaptureType capType;
   unsigned int fngr;
	eFingerType ftype[NUM_FNGRS] = { 
	 (eFingerType)FNGR_LFOUR,
    (eFingerType)FNGR_LTHUMB,
	 (eFingerType)FNGR_RFOUR,
    (eFingerType)FNGR_RTHUMB,
    (eFingerType)FNGR_THUMBS,
    (eFingerType)FNGR_LTHUMB,
    (eFingerType)FNGR_LINDEX,
    (eFingerType)FNGR_LMIDDLE,
    (eFingerType)FNGR_LRING,
    (eFingerType)FNGR_LLITTLE,
    (eFingerType)FNGR_RTHUMB,
    (eFingerType)FNGR_RINDEX,
    (eFingerType)FNGR_RMIDDLE,
    (eFingerType)FNGR_RRING,
    (eFingerType)FNGR_RLITTLE,
    (eFingerType)FNGR_LHAND,
    (eFingerType)FNGR_LWRITERS,
    (eFingerType)FNGR_LPALM,
    (eFingerType)FNGR_RHAND,
    (eFingerType)FNGR_RWRITERS,
    (eFingerType)FNGR_RPALM
	};
   U32 numFngrs;

   // ==> Define the capture sequence here:
#define NUM_FNGRS_IN_SEQ    3   
   U32 fngrSeq[NUM_FNGRS_IN_SEQ] = { 0, 2, 4  };   // 4-4-2 Slap Sequence
   // <==

//#define TIME_DISPLAY
#ifdef TIME_DISPLAY
   DWORD dwStartTicks = GetTickCount();
#endif
      // Slap Capture Sequence?
   if (((CButton*)GetDlgItem(IDC_RADIO_SEQ))->GetCheck() != BST_CHECKED)
   {
      numFngrs = 1;
      fngrSeq[0] = m_fngr->GetCurSel();
   }
   else numFngrs = NUM_FNGRS_IN_SEQ;

		// Validate RTQA Threshold
	char thrshld[4];
	if (((CStatic *)GetDlgItem(IDC_EDIT_RTQA))->GetWindowText(thrshld,4))
		m_RTQAThrhld = atoi(thrshld);
	if ((m_RTQAThrhld < 0) || (m_RTQAThrhld > 100))
	{
		MessageBox("Invalid RTQA Threshold.  ",
			"Parameter Error",MB_ICONERROR);
		return;
	}
      // Image Resolution Requested
   if (((CButton*)GetDlgItem(IDC_RADIO_1000))->GetCheck() == BST_CHECKED)
      m_bmImage.resolution = 1000;
   else if (((CButton*)GetDlgItem(IDC_RADIO_500))->GetCheck() == BST_CHECKED)
      m_bmImage.resolution = 500;
   else m_bmImage.resolution = 0;

   for (U32 i = 0; i < numFngrs; i++)
   {
      fngr = fngrSeq[i];
      capType = cTypes[fngr];

      // Validate that the capture type is supported
   	bool res; long r;
	   if ((r = TP_IsCaptureTypeSupported(m_hDev, capType, &res)) != TPAPI_NOERROR)
	   {
		   MessageBox(GetErrorMsg(r),"Capture Error",MB_ICONERROR);
		   return;
	   }
	   else if (!res)
	   {
		   MessageBox("The scanner does not support the selected "
			   "capture type.    \n\r\n\rPress OK to continue",
			   "Start Capture",MB_ICONINFORMATION);
		   return;
	   }
		   // Validate that the scanner is calibrated
	   if ((r = TP_IsCalibrated(m_hDev, capType, &res)) != TPAPI_NOERROR)
	   {
		   MessageBox(GetErrorMsg(r),"Start Capture",MB_ICONERROR);
		   return;
	   }
	   else if (!res)
	   {
		   MessageBox("The scanner requires calibration prior to "
			   "capturing fingerprints.  Please \n\rcalibrate the "
			   "scanner for the selected capture type, and retry "
			   "the capture.    \n\r\n\rPress OK to continue",
			   "Calibrate Scanner",MB_ICONINFORMATION);
		   return;
	   }
		   // Validate that auto capture is supported if selected
	   m_CaptureMode &= ~(CMODE_AUTO_CAP|CMODE_AUTO_CAP_WITH_PREVIEW);
      if (m_chkAutoCap->GetCheck() == BST_CHECKED) 
      {
         if ((r = TP_IsAutoCaptureSupported(m_hDev, capType, &res)) != TPAPI_NOERROR)
		   {
   			MessageBox(GetErrorMsg(r),"Capture Error",MB_ICONERROR);
	   		return;
		   }
		   else if (!res)
		   {
			   MessageBox("The scanner does not support auto-capture for the "
               "selected capture type.    \n\r\n\rPress OK to continue",
	   			"Start Capture",MB_ICONINFORMATION);
		   	return;
		   }
         else if (cTypeInfo[capType].base_ctype == CTYPE_ROLL)
         {
            idcBtn = (CButton*)GetDlgItem(IDC_RADIO_INK);
	         m_CaptureMode |= (idcBtn->GetCheck() == BST_CHECKED) 
	         	      ? CMODE_AUTO_CAP : CMODE_AUTO_CAP_WITH_PREVIEW;
         }
         else m_CaptureMode |= CMODE_AUTO_CAP;
	   }

      //---------------------------------------------------------
      //          Open Capture Window - Start Preview
      //---------------------------------------------------------
      captureDlg = new CCaptureDlg(m_hDev,ftype[fngr],capType,
         m_CaptureMode,m_RTQAThrhld,this);
      if ((captureDlg->DoModal() == IDOK) && captureDlg->XSize && captureDlg->YSize)
      {
         bmpMutex->Lock();
         if (SetupBitmap(UNDECORATED,captureDlg->XSize,captureDlg->YSize,
            &m_bmImage.bm,&pBitmapData) == TPAPI_NOERROR)
         {		// copy new image from CaptureDlg
            XSize = captureDlg->XSize;
            YSize = captureDlg->YSize;
            if ((XSize * YSize > 0) && (captureDlg->m_pImageBuf != NULL))
            {
               memcpy(pBitmapData,captureDlg->m_pImageBuf,XSize*YSize);

                  // set image window title
               TCHAR title[128];
               if (((CStatic*)GetDlgItem(IDC_EDIT_NAME))->GetWindowText(title,100) > 0)
                  _tcscat(title," - ");
               _tcscat(title,fngrName[fngr]);
#ifdef TIME_DISPLAY
               sprintf(title,"%s - Total Time: %d mSec",title,GetTickCount()-dwStartTicks);
#endif
               ((CStatic*)GetDlgItem(IDC_TITLE_FNGR))->SetWindowText(title);
               Invalidate();
            }
         }
         else MessageBox("Error allocating display bitmap resources.  ",
            "Out of Resources",MB_ICONERROR);
         bmpMutex->Unlock();
      }
      delete captureDlg;
   }
}

//-------------------------------------------------------
//		OnBnClickedRTQA
//			Toggle RTQA capture mode
//-------------------------------------------------------
void CTPAPISampleAppDlg::OnBnClickedRTQA()
{
	unsigned long capMode = m_CaptureMode;

	capMode &= ~CMODE_RTQA;
	capMode |= (((CButton*)
		GetDlgItem(IDC_CHK_RTQA))->GetCheck() == BST_CHECKED) 
		? CMODE_RTQA : 0;
   m_CaptureMode = capMode;
}

//-------------------------------------------------------
//		OnBnClickedReview
//			Toggle Operator Review capture mode
//-------------------------------------------------------
void CTPAPISampleAppDlg::OnBnClickedReview()
{
	unsigned long capMode = m_CaptureMode;

	capMode &= ~CMODE_REVIEW;
	capMode |= (((CButton*)
		GetDlgItem(IDC_CHK_REVIEW))->GetCheck() == BST_CHECKED) 
		? CMODE_REVIEW : 0;
   m_CaptureMode = capMode;
}

//-------------------------------------------------------
//		OnBnClickedAutoCap
//			Enable/disable autoCap mode radio buttons
//-------------------------------------------------------
void CTPAPISampleAppDlg::OnBnClickedAutoCap()
{
   CButton *idcBtn;
   bool bAutoCap = m_chkAutoCap->GetCheck() == BST_CHECKED;
   idcBtn = (CButton*)GetDlgItem(IDC_RADIO_INK);
   idcBtn->EnableWindow(bAutoCap ? SW_SHOW : SW_HIDE);
   idcBtn = (CButton*)GetDlgItem(IDC_RADIO_NOINK);
   idcBtn->EnableWindow(bAutoCap ? SW_SHOW : SW_HIDE);
}

//-------------------------------------------------------
//		OnBnClickedRadio500
//			Change the resolution of the scanner to 500dpi
//-------------------------------------------------------
void CTPAPISampleAppDlg::OnBnClickedRadio500()
{
	if (((CButton*)GetDlgItem(IDC_RADIO_500))->GetCheck() == BST_CHECKED)
   {     // Change all capture types to the desired resolution
      for (int i = 0; i < NUM_FNGRS; i++)
      {
         long r;
         enum eCaptureType capType = cTypeInfo[i].base_ctype;
      	bool bSupported = false; 
   
         TP_IsCaptureTypeSupported(m_hDev, capType, &bSupported);
         if (bSupported && 
            ((r = TP_SetResolution(m_hDev,capType,500)) != TPAPI_NOERROR))
   		{
   			((CButton*)GetDlgItem(IDC_RADIO_500))->SetCheck(BST_UNCHECKED);
   			((CButton*)GetDlgItem(IDC_RADIO_1000))->SetCheck(BST_CHECKED);
   			MessageBox(GetErrorMsg(r),"Set Resolution Error",MB_ICONERROR);
   		}
      }
   }
}

//-------------------------------------------------------
//		OnBnClickedRadio1000
//			Change the resolution of the scanner to 1000dpi
//-------------------------------------------------------
void CTPAPISampleAppDlg::OnBnClickedRadio1000()
{
	if (((CButton*)GetDlgItem(IDC_RADIO_1000))->GetCheck() == BST_CHECKED)
   {     // Change all capture types to the desired resolution
      for (int i = 0; i < NUM_FNGRS; i++)
      {
         long r;
         enum eCaptureType capType = cTypeInfo[i].base_ctype;
      	bool bSupported = false; 
   
         TP_IsCaptureTypeSupported(m_hDev, capType, &bSupported);
         if (bSupported && 
            ((r = TP_SetResolution(m_hDev,capType,1000)) != TPAPI_NOERROR))
   		{
   			((CButton*)GetDlgItem(IDC_RADIO_1000))->SetCheck(BST_UNCHECKED);
   			((CButton*)GetDlgItem(IDC_RADIO_500))->SetCheck(BST_CHECKED);
   			MessageBox(GetErrorMsg(r),"Set Resolution Error",MB_ICONERROR);
   		}
      }
   }
}

//-------------------------------------------------------
//		OnBnClickedBtnCalibrate
//			Calibrate the selected scanner
//-------------------------------------------------------
void CTPAPISampleAppDlg::OnBnClickedBtnCalibrate()
{
	long r;
	bool calSupport;
	enum eCaptureType capType[NUM_SCANTYPES] = 
		{ CTYPE_HAND,CTYPE_SLAP_ONE,CTYPE_SLAP_FOUR,CTYPE_SLAP_PALM };
	TCHAR calPrep[256] = { "Thoroughly clean the scanner "
		"platen and close the cover (if available).   " };

	unsigned int scnType = m_calib->GetCurSel();
	if ((r = TP_IsCalibrationSupported(m_hDev,capType[scnType],&calSupport))
		!= TPAPI_NOERROR)
		MessageBox(GetErrorMsg(r),"Calibration Error",MB_ICONERROR);
	else if (calSupport)
	{
      if (capType[scnType] == CTYPE_HAND)
      {
         _tcscat(calPrep,"\n\n"
            "After the first beep, roll the drum wheel "
            "slowly until you hear the second beep.   ");
      }
      bool bRetryCalibrate;
      do
      {
         bRetryCalibrate = false;
         if (MessageBox(calPrep,"Calibrate Scanner",MB_OKCANCEL) != IDCANCEL)
         {
            HCURSOR hCur = SetCursor(hIdxCursor);
            Invalidate();
            r = TP_CalibrateScanner(m_hDev,capType[scnType]);
            SetCursor(hCur);
            if (r != TPAPI_NOERROR)
            {
               if (r == TPAPI_INVALIDSTATE)
               {
                  char errMsg[64];
                  sprintf(errMsg,"%s\n\nReset Device and Retry?",GetErrorMsg(r));
                  if (MessageBox(errMsg,"Calibration Error",
                     MB_ICONERROR|MB_OKCANCEL) == IDOK) 
                  {
                     hCur = SetCursor(hIdxCursor);
                     TP_ResetDevice(m_hDev);
                     SetCursor(hCur);
                     bRetryCalibrate = true;
                  }
               }
               else if ((capType[scnType] == CTYPE_HAND) && (r == TPAPI_BADRESPONSE))
                  MessageBox("The drum was rolled too fast or too slow.    "
                  "\r\n\nPlease re-calibrate...","Calibration Error",MB_ICONERROR);
               else
                  MessageBox(GetErrorMsg(r),"Calibration Error",MB_ICONERROR);
            }
            else
               MessageBox("Calibration completed successfully!    \n\r\n\r"
                  "Press OK to continue","Calibrate Scanner",MB_ICONINFORMATION);
         }
      } while (bRetryCalibrate);
   }
   else 
      MessageBox("Calibration is not supported for the "
         "selected capture type.    \n\r\n\rPress OK to "
         "continue","Calibrate Scanner",MB_ICONINFORMATION);
}

//-------------------------------------------------------
//		OnBnClickedBtnSaveas
//			Save finished image in TIF format file
//-------------------------------------------------------
void CTPAPISampleAppDlg::OnBnClickedBtnSaveas()
{
	char title[128];
	((CStatic*)GetDlgItem(IDC_TITLE_FNGR))->GetWindowText(title,100);
	CFileDialog fileDlg(FALSE,"tif",title,OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT,
		"TIF files (*.tif)|*.tif|All files (*.*)|*.*||",this);

	fileDlg.m_ofn.lpstrTitle = "Save Image Dialog";

	if (fileDlg.DoModal() == IDOK)
	{		// This is your selected file name with path
		CString szFile = fileDlg.GetPathName();
		BITMAP bm;
		if (m_bmImage.bm.GetBitmap(&bm))
		{
			TiffInfo t;
			t.bitsPerSample = 8;
			t.imageWidth = bm.bmWidth;
			t.imageLength = bm.bmHeight;
			t.xResolution = m_bmImage.resolution;
			t.yResolution = m_bmImage.resolution;
			t.photometric = 1;
			if (fileDlg.GetFileExt() == "")
				szFile += ".tif";
			writeTiffFile(szFile.GetBuffer(0), pBitmapData,&t);
			szFile.ReleaseBuffer();
		}
	}
}

//-------------------------------------------------------
//		OnCbnSelchangeDevice
//			New Device Selected
//-------------------------------------------------------
void CTPAPISampleAppDlg::OnCbnSelchangeDevice()
{
   HCURSOR hCur = SetCursor(hIdxCursor);
   if (m_hDev != INVALID_HANDLE)
   {
      TP_CloseDevice(m_hDev);
      m_hDev = INVALID_HANDLE;
   }
   m_deviceConnected = false;
   if (m_device->GetCount() > 0)
   {
      int i = m_device->GetCurSel();
      TP_OpenDevice(m_devList[i].devName,m_devList[i].libType,&m_hDev);
      UpdateDeviceStatus();
      m_deviceConnected = !m_deviceConnected;
      UpdateDeviceStatus();
   }
   SetCursor(hCur);
}

//-------------------------------------------------------
//		OnBnClickedBtnRefresh
//			Refresh the Devices ComboBox
//-------------------------------------------------------
void CTPAPISampleAppDlg::OnBnClickedBtnRefresh()
{
	HCURSOR hCur = SetCursor(hIdxCursor);
   if (m_hDev != INVALID_HANDLE)
   {
      TP_CloseDevice(m_hDev);
      m_hDev = INVALID_HANDLE;
   }
   m_deviceConnected = false;
   UINT numDev = MAX_DEVLIST;
   if (TP_GetDeviceList(&numDev, m_devList) == TPAPI_NOERROR)
   {
      m_device->ResetContent();
      for (unsigned int i = 0; i < numDev; i++)
      {
			TCHAR devText[128];
         TCHAR strLink[32];
         switch(m_devList[i].libType)
         {
         case 0:
            strcpy_s(strLink,32,"USB 2.0"); break;
         case 1:
            strcpy_s(strLink,32,"IEEE1394 OHCI"); break;
         case 2:
            strcpy_s(strLink,32,"IEEE1394 Unibrain"); break;
         default:
            strcpy_s(strLink,32,"Unknown");
         }
			_stprintf(devText,"  %s - S/N %s - %s",
   			m_devList[i].assy_model,m_devList[i].assy_sn,strLink);
         m_device->InsertString(i,devText);
      }
     	m_device->SetCurSel(0);
      OnCbnSelchangeDevice();
   }
	SetCursor(hCur);
}

//-------------------------------------------------------
//
//-------------------------------------------------------
void CTPAPISampleAppDlg::EnableGUI(bool bEnable)
{
   m_BtnCalibrate->EnableWindow(bEnable);
   m_BtnStartCapture->EnableWindow(bEnable);
}

//-------------------------------------------------------
//		UpdateDeviceStatus
//			Determine if the device is connected and 
//			update the display with device information
//-------------------------------------------------------
void CTPAPISampleAppDlg::UpdateDeviceStatus(void)
{
   if (bTPAPIInitialized && TP_DeviceConnected(m_hDev))
	{ 
		if (!m_deviceConnected)
		{
			m_deviceConnected = true;
			struct s_devInfo devInfo;
			if (TP_GetDeviceInfo(m_hDev,&devInfo) == TPAPI_NOERROR)
			{
				TCHAR devText[128];
				_stprintf(devText,"==   Firmware Version:  %s   ==",devInfo.sw_version);
				GetDlgItem(IDC_STATUS)->SetWindowText(devText);
			}
			else GetDlgItem(IDC_STATUS)->
				SetWindowText("** Error Retrieving Version Info **");

			U32 curRes = 500;
			if (TP_GetResolution(m_hDev, CTYPE_SLAP_FOUR, &curRes) == TPAPI_NOERROR)
			{
				((CButton*)GetDlgItem(IDC_RADIO_500))->SetCheck((curRes == 1000) ? BST_UNCHECKED : BST_CHECKED);
				((CButton*)GetDlgItem(IDC_RADIO_1000))->SetCheck((curRes == 1000) ? BST_CHECKED : BST_UNCHECKED);
			}
		   EnableGUI(true);
         enum eHandSz hndSz;
         bool handSupported;
      	if ((TP_IsCaptureTypeSupported(m_hDev,CTYPE_HAND,&handSupported) 
                 == TPAPI_NOERROR) && handSupported)
            if ((TP_GetMaxHandSize(m_hDev,&hndSz) == TPAPI_NOERROR) &&
                  (hndSz != (enum eHandSz)TP_HAND_10_INCH))
               TP_SetMaxHandSize(m_hDev,TP_HAND_10_INCH);
      }
	}
	else if (m_deviceConnected)
	{
      GetDlgItem(IDC_STATUS)->SetWindowText("   Device Not Connected   ");
      EnableGUI(false);
		m_deviceConnected = false;
	}
}

